const testEnv = require('./src/config/environments/unit-test');

module.exports = {
  globals: {
    environment: testEnv,
  },
  transform: {
    '\\.(js)$': 'babel-jest',
  },
  collectCoverageFrom: [
    'src/**/*.js',
  ],
  setupFiles: [
    '<rootDir>/.jest/jest.awsPayloadBuilder.js',
    '<rootDir>/.jest/jest.winstonSetup.js',
    '<rootDir>/.jest/jest.envVars.js',
  ],
  setupFilesAfterEnv: [
    '<rootDir>/.jest/jest.afterEnv.js',
  ],
  roots: [
    '<rootDir>/src/',
  ],
  testMatch: [
    '**/*.spec.js',
  ],
  watchPlugins: [
    'jest-watch-typeahead/filename',
    'jest-watch-typeahead/testname',
  ],
  clearMocks: true,
};
