# demo.okta Application - Node Quickstart

A quickstart application for token demonstration using the demo.okta API written in Node.js with Express for Customer Identity Cloud (CIC), Okta Customer Identity Solution (OCIS) and Workforce Identity Cloud (WIC) products.

The Demo API provides the powerful ability to reuse applications with different IDPs and environments. The delivery of OIDC configuration and settings for each demonstration on the fly is done through the `/bootstrap` endpoint of the [demo.okta API](https://docs.demo.okta.com).

This quickstart acheives multi-tenancy with the implementation found in 'tenantResolver.js'. Using the subdomain of the requesting host as the demo name, the application requests the configuration for the application id it registered with within the context of demo enviornment (identified by the demo name). When an instance of the application is found the returned OIDC settings are used to register `Passport.js` strategies for that demo. A loose overview is shown in diagram below.

![Entity diagram](diagram.svg)

# No Code Quickstart

If you are new to demo.okta please review [learn.demo.okta.com](https://learn.demo.okta.com) to understand some broader context and features before diving into using Quickstart. The Learn portal provides a rich set of guides and will help you setup you first demonstration environments.

This quickstart is deployed within [Builder](https://builder.demo.okta.com) as a managed application. This enables the ability for this codebase to be deployed to a demonstration without touching code. 

To see this quickstart in action follow these steps:

1. Go to [Builder](https://builder.demo.okta.com), signing in if necessary.
2. If you have an existing demonstration that you wish to use, click that demonstrations card and skip to step 3
    1. If you don't have a demonstration, click _New Demo_ and setup a new Demo as required.
    2. Wait for the Demonstration to load and be marked as active.
3. Click _Add Application_ 
4. In the _Managed applications_ section find _Quickstart_ and select _Attach_. You'll be redirected back to the demonstration details pane.
5. Wait for the demonstration and _Quickstart_ application to be marked as active and then click _Launch_. This opens a new tab to the application.
6. Login. You will see the parsed claims from your OIDC tokens.

# Running Quickstart

This quickstart is intended to allow quick prototyping of a demo OIDC application that reflects some real world use case and include it as part of a demonstration built in [Builder](https://builder.demo.okta.com). Following these steps will place your custom application, built using Quickstart as a base, into the Builder alongside all the existing Applications available. Your custom application will be available to you only as a private application.

## Prerequisites

This following tools are required in order to develop this Node Quickstart application.

1. An Interactive Development Environment (IDE). As these are personal choices we suggest one that you are comfortable with and that supports Javascript and Node natively or through a well supported plugin system. The demo.okta team tend to use VSCode which provides the vesatility we require.
1. Node and NPM. This repository currently targets Node 16.0 which is the Long Terms Support (LTS) version. 
1. Git (Optional) - If you wish to keep track of changes or collaborate with others wrapping this codebase in Version control is highly recommended. If you're only building this out as a local application this is not required.
1. NVM (Optional) or a similar node version management utility. This allows you to install multiple versions of node and control which version is used to build and run applicationd.


## On your local machine

Running Quickstart locally is the simplest way to get started. The following steps will setup a Quickstart Application to work with the demo.okta API;

1. Go to [Builder](https://builder.demo.okta.com), signing in if necessary.
2. Click _New Application_ 
3. Create a new application by giving it a name and a brief description; e.g. `Local Quickstart`. 
    1. Set the _Base Address_ to `http://localhost:3000`.
    2. Make sure _Multi-tenant aware_ is checked.
    3. Click _Create_. Other settings are described later in this guide.
4. Make a copy of the following fields. You will need them for your `.env` file.
    * Application Id
    * Client Id
    * Client Secret
5. In your favourite developer tool (IDE) make a copy of the `.env.sample` file and call it `.env`. **NB:** If using version control this file should be ignored and NEVER checked in.
6. Set the following empty environment variables in `.env` with the values copied from builder:
```
DEMO_API_APP_ID=[Application Id]
DEMO_API_CLIENT_ID=[Client Id]
DEMO_API_CLIENT_SECRET=[Client Secret]
```
7. In a terminal/CLI run `npm start`
8. Back in [Builder](https://builder.demo.okta.com); If you have an existing demonstration that you wish to use, click that demonstrations card and skip to step 9
    1. If you don't have a demonstration, click _New Demo_ and setup a new Demo as required. 
    2. Wait for the Demonstration to be marked as active.
9. Click _Add Application_ 
10. In the _Your applications_ section find the application you created in the 'Your application' row and select _Attach_. You'll be redirected back to the demonstration details pane.
11. Wait for the demonstration and your application to be marked as active and then click _Launch_. This opens a new tab to http://<your_demo_name>.localhost:3000 and your local instance of Quickstart will configure itself for your demonstration.
12. Login. You will see the parsed claims from your OIDC tokens. **NB:** For Okta based IDPs you will need to assign the application to the user you are logging in with.


### Working with Hooks

The demo.okta API provides webhook for four application lifecycle events (Request, Create, Update, Destroy). These allow the application to perform any configuration is needs either to the IDP or supporting resources. Each of these webhooks can be registered against the application in [Builder](https://builder.demo.okta.com). 

* Request

    The request webhook can be used to prevent the creation of a application instance for example if your application does not support a given IDP or has a licensing requirement.

* Create

    The create webhook indicates that a demo has been created and an OIDC client has been registered to the demo IDP for this application. The payload for this hook includes a management credential for the demo IDP to allow your application to perform any additional setup that is required for example creating rules.

* Update

    The update hook is fired when a user changes the provided settings for the application instance.

* Delete

    The delete hook is fired when the removes the application from their demonstration. Your application should use the provided management credentials to remove any created objects. The OIDC client itself will be removed by the Demo API.

Webhooks are completely optional; you can implement as few or as many as you wish. Each webhook that is provided must be a valid https URI.
When any webhook is called it must respond with a HTTP Accepted (202) response code, acknowledging the receipt of the payload, within three seconds else the application instance will be marked as `error`.
The most up to date payload for each of these webhooks can be found in the [API docs](https://docs.demo.okta.com), and form part of the demo.okta API contract with consuming clients. 

#### NGrok Configuration

Enabling webhooks for an application is relatively straightforward. Routing the webhooks request to the running application is a little more tricky when running from your localhost. As the webhooks are called from the demo.okta API using `localhost` as the URI host will not work as demo.okta has no clue where to route the request to. To support webhooks on your local machine we're going to use NGrok. NGrok is a CLI application that provides a bridge between your local machine and the public facing internet. It provides a generated HTTPs URL that maps to a port on your localhost. This is extremely useful for running applications that fully make use of webhooks.

To get up and running with ngrok:

1. Go to [ngrok.com](ngrok.com), to sign up for an account and download the client.
2. Follow the [guide on the ngrok dashboard](https://dashboard.ngrok.com/get-started/setup) to get setup.
3. Launch NGrok for your application 

```
ngrok http 3000
```

This will give you an address you can use in [Builder](https://builder.demo.okta.com) to point the application's webhooks at your local machine. By default ngrok gives you two hours of usage before you need to restart the connection which will change the address.

#### Application Setup

1. Go to [Builder](https://builder.demo.okta.com), signing in if necessary.
2. Select your application.
3. Click Edit
4. In the _Lifecycle Hooks_ section enter the complete URI for any of the lifecycle events you want to use. For Quickstart the path is `<base_address>/hooks/<lifecycle_event>`. If using ngrok remember the base address is the ngrok address followed by the path to the webhook route for example (`https://b75c-109-154-20-209.eu.ngrok.io/hooks/create`).
5. Click save.
6. In a terminal/CLI local to your application run `npm start`
7. Trigger a lifecycle event:
    * When an instance is requested (i.e. you hit attach in builder) you will see the request webhook fire, followed by the create webhook if request is not set or responds with 200.
    * When an instance is updated (i.e. on label change, settings change etc) you will see an Update webhook fire
    * When an instance is deleted/application detached from a demonstration you will see a Destory webhook fire.

## Remote

Hosting means that your application can be more widely shared as a community application. It also make setting up webhooks (see later) easier since the hosted application should have a statically addressible host.

The requirements for multi-tenancy means that certain hosting providers can not provide on-demand hosting such as Glitch.

### AWS Elastic Beanstalk

Our recommended option is to host within AWS Elastic Beanstalk. 

From within AWS Route 53 you can point a custom domain (mydemo.example.com) to the Elastic Beanstalk instance with an A record, you can then also point the wildcard of the same address (*.mydemo.example.com) to the same instance.

### Vercel

Hosting for SPA apps with the webhooks being delivered as serverles functions. This is how the Streamward community application is hosted.

### Cloudflare

Cloudflare only support a first level subdomain on their free tier (*.example.com) any attempt to do multiple subdomains will result in a cypher mismatch error. To support multiple levels you must purchase their Advanced Certificate Manager Add-On ($10 month).

### Others

If you have a deployment guide for other providers that works please reach out to #demo-eng-community.
